/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import java.util.Collections;
import java.util.HashMap;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.monster.SilverfishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.handler.ModuleHandler;
import svenhjol.charm.base.helper.MobHelper;
import svenhjol.charm.base.helper.PosHelper;
import svenhjol.charm.base.iface.Config;
import svenhjol.charm.base.iface.Module;
import svenhjol.charm.block.EnderPearlBlock;
import svenhjol.charm.entity.goal.FormEndermiteGoal;

@Module(mod="charm", description="Ender pearl storage. Eating a chorus fruit will teleport you to the nearest ender pearl block.", hasSubscriptions=true)
public class BlockOfEnderPearls
extends CharmModule {
    public static EnderPearlBlock ENDER_PEARL_BLOCK;
    @Config(name="Chorus teleport range", description="A chorus fruit will teleport you to an ender pearl block within this range (in blocks).")
    public static int teleportRange;
    @Config(name="Chorus fruit teleport", description="If true, eating a chorus fruit while in range of an ender pearl block will teleport you to it.")
    public static boolean chorusTeleport;
    @Config(name="Convert silverfish to endermite", description="If true, a silverfish has a chance to be converted into an endermite when it is next to an ender pearl block.")
    public static boolean convertSilverfish;

    @Override
    public void register() {
        ENDER_PEARL_BLOCK = new EnderPearlBlock(this);
    }

    @SubscribeEvent
    public void onEnteringChunk(EntityEvent.EnteringChunk event) {
        if (!event.isCanceled()) {
            this.addGoalToSilverfish(event.getEntity());
        }
    }

    public static boolean tryChorusTeleport(LivingEntity entity, ItemStack stack) {
        double z;
        double y;
        if (!ModuleHandler.enabled(BlockOfEnderPearls.class) || !chorusTeleport) {
            return false;
        }
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        if (entity.field_70170_p.field_72995_K) {
            return false;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)entity;
        BlockPos playerPos = player.func_233580_cy_();
        World world = player.field_70170_p;
        HashMap foundPositions = new HashMap();
        BlockPos.func_218281_b((BlockPos)playerPos.func_177982_a(-teleportRange, -teleportRange, -teleportRange), (BlockPos)playerPos.func_177982_a(teleportRange, teleportRange, teleportRange)).forEach(blockPos -> {
            BlockPos abovePos = blockPos.func_177981_b(1);
            BlockState stateAtPos = world.func_180495_p(blockPos);
            if (stateAtPos.func_177230_c() != ENDER_PEARL_BLOCK) {
                return;
            }
            if (abovePos.equals((Object)playerPos)) {
                return;
            }
            BlockState state1 = world.func_180495_p(blockPos.func_177981_b(1));
            BlockState state2 = world.func_180495_p(blockPos.func_177981_b(2));
            if (state1.func_185904_a() != Material.field_151579_a || state2.func_185904_a() != Material.field_151579_a) {
                return;
            }
            double dist = PosHelper.getDistanceSquared(playerPos, abovePos);
            foundPositions.put(dist, abovePos);
        });
        if (foundPositions.isEmpty()) {
            return false;
        }
        BlockPos targetPos = (BlockPos)foundPositions.get(Collections.min(foundPositions.keySet()));
        if (targetPos == null) {
            return false;
        }
        double x = (double)targetPos.func_177958_n() + 0.5;
        boolean didTeleport = player.func_213373_a(x, y = (double)targetPos.func_177956_o(), z = (double)targetPos.func_177952_p() + 0.5, true);
        if (!didTeleport) {
            return false;
        }
        SoundEvent teleportSound = SoundEvents.field_187544_ad;
        world.func_184148_a(null, x, y, z, teleportSound, SoundCategory.PLAYERS, 1.0f, 1.0f);
        player.func_184185_a(teleportSound, 1.0f, 1.0f);
        player.func_184811_cZ().func_185145_a(Items.field_185161_cS, 20);
        if (!player.func_184812_l_()) {
            stack.func_190918_g(1);
        }
        return true;
    }

    private void addGoalToSilverfish(Entity entity) {
        if (!convertSilverfish) {
            return;
        }
        if (!(entity instanceof SilverfishEntity)) {
            return;
        }
        SilverfishEntity silverfish = (SilverfishEntity)entity;
        GoalSelector goalSelector = MobHelper.getGoalSelector((MobEntity)silverfish);
        if (goalSelector.func_220888_c().noneMatch(g -> g.func_220772_j() instanceof FormEndermiteGoal)) {
            goalSelector.func_75776_a(2, (Goal)new FormEndermiteGoal(silverfish));
        }
    }

    static {
        teleportRange = 8;
        chorusTeleport = true;
        convertSilverfish = true;
    }
}

